# Library Management System using Python on Django Framework

### About the Project
Library Management System Project created with Django. Developed web services using Python (Django Framework) where an admin can perform <code>C R U D</code> (Create, Read, Update and Delete) operations

**Prerequisite:** 

Backend: <code>[Python](https://github.com/mrankitgupta/Python-Roadmap)</code> 📑 & <code>[Django Framework](https://github.com/mrankitgupta)</code> 🗂️

Frontend: <code>[HTML](https://github.com/mrankitgupta)</code> & <code>[CSS](https://github.com/mrankitgupta)</code>

### Objective

**Anyone can**

1. see all the books in homepage

2. search books based on author or name of the book or category of the book

3. sort books or author alphabetically

**Student can**

1. login / signup ,

2. can request book

3. see their own issues and filter them based on :
   * requested issues ,
   * issued books or
   * all of them together
   
4. check their own fines

5. can see
   * the days remaining to return a particular book or
   * the number of days passed the return date of a particular book in the my fines page

**Admin can**

1. login to admin dashboard

2. check all issues :
   * see issues ,
   * delete issues ,
   * search issues by studentid
   * filter issues based on :
      * issued or not,
      * returned or not ,
      
3. accept a issue :
   * from the dashboard where admin has to manually select return date or
   * from the Issue requests page where return date is automatically calculated

4. add , delete search books and filter books based on author

5. add , delete , search author

6. calculate fine by clicking a button ,

7. create, delete fine ,search fines for studentid

8. toggle fine paid status (if paid in cash)

9. search ,modify,add,delete students , filter them based on department and check all fines and issues of that student

10. can see the last-login , date joined & the student associated to a particular user

11. can change password for any user

**More ...**

1. While signing up if studentID is already associated to a user in this platform then it will show a error without reloading the page and as soon as correct id is given then the error will go away

2. Books in homepage will show status of issued , issue requested or request issue based on whether the book is issued or requested for a issue or is not requested for logged-in students only


## Technologies used ⚙️

* <a href="https://github.com/mrankitgupta/Python-Roadmap">Python</a> <a href="https://github.com/mrankitgupta/Python-Roadmap" target="_blank"> <img src="https://raw.githubusercontent.com/devicons/devicon/master/icons/python/python-original.svg" alt="python" width="25" height="20"/> </a>

* <a href="https://github.com/mrankitgupta">Django</a> <a href="https://www.djangoproject.com/" target="_blank" rel="noreferrer"> <img src="https://github.com/mrankitgupta/mrankitgupta/blob/main/images/icons8-django.svg" alt="django" width="40" height="30"/> </a>

* <a href="https://github.com/mrankitgupta">HTML</a> <a href="https://www.w3.org/html/" target="_blank" rel="noreferrer"> <img src="https://raw.githubusercontent.com/devicons/devicon/master/icons/html5/html5-original-wordmark.svg" alt="html5" width="40" height="30"/> </a>

* <a href="https://github.com/mrankitgupta">CSS</a> 

## For any queries/doubts 🔗 👇 

### [Ankit Gupta](https://bio.link/AnkitGupta)
<p align="left"> <a href="https://twitter.com/MrAnkitGupta_/" target="blank"><img src="https://img.shields.io/twitter/follow/MrAnkitGupta_?logo=twitter&style=for-the-badge" alt="MrAnkitGupta_" /></a> </p>

<a href="https://www.linkedin.com/in/mrankitgupta" target="blank"><img align="center" src="https://img.shields.io/badge/-MrAnkitGupta-blue?style=flat-square&logo=Linkedin&logoColor=white&link=https://www.linkedin.com/in/mrankitgupta/" alt="MrAnkitGupta" height="20" width="100" /></a>
<a href="https://www.instagram.com/MrAnkitGupta_" target="blank"><img align="center" src="https://img.shields.io/badge/-@MrAnkitGupta_-D7008A?style=flat-square&labelColor=D7008A&logo=Instagram&logoColor=white&link=https://www.instagram.com/MrAnkitGupta_" alt="MrAnkitGupta_" height="20" width="110" /></a>
<a href="https://bio.link/AnkitGupta" target="blank"><img align="center" src="https://img.shields.io/badge/website-000000?style=for-the-badge&logo=About.me&logoColor=white&link=https://bio.link/AnkitGupta" alt="AnkitGupta" height="20" width="90" /></a>
<a href="https://github.com/mrankitgupta/" target="blank"><img align="center" src="https://img.shields.io/github/followers/mrankitgupta?label=Follow&style=social&link=https://github.com/mrankitgupta/" alt="MrAnkitGupta" height="20" width="90" /></a>

  
